/**********************************************************************
*	Bastion Products Copyright 1998								*
*	All rights reserved										*
*	This source is freely distributable in an unmodified state.		*
*	Last Modified:	5/20/98									*
*	Author:			Jennifer Weston							*
***********************************************************************/
#ifndef _BLITHE_H_
#define _BLITHE_H_

#include <OS.h>
/*
**	Static C Interface
**   With the exception of blithe_init, these functions are used in case the blithe.so is not found
**   If the BlitheDictionary class has not been instantiated, blithe_init must be called before
**   using any other Blithe function.
*/
status_t blithe_init(void);
int static_has_application_dictionary(int32 inLangID);
int32 static_get_default_language(void);
char* static_get_entry(int32 inStringID, int32 inLangID, char* inBuffer, int32 inBuffSize);
void* static_get_blob(uint32 inResType,int32 inResID, int32 inLangID, void* inBuffer, size_t inBuffLength, size_t* outBlobSize);
int32 static_get_entry_length(int32 inStringID, int32 inLangID);
int32 static_get_max_length(int32 inLangID);
int32 static_get_language_list(char** outList);
char* static_language_name(int32 inLangID, char* inBuffer, int32 inBuffSize);
int32 static_language_id(char *inName);
size_t static_get_raw_bits(void** theBits);

/* Set up a series of function pointers that are assigned at initialization */
/* Check to see if a given language id has an application dictionary */
extern int (*has_application_dictionary)(int32 inLangID);

/* Returns the user-configured default language */
extern int32 (*get_default_language)(void);

/* Gets an entry */
extern char* (*get_entry)(int32 inStringID, int32 inLangID, char* inBuffer, int32 inBuffSize);

/* Gets a blob (arbitrary resource type/id) */
extern void* (*get_blob)(uint32 inResType,int32 inResID, int32 inLangID, void* inBuffer, size_t inBuffLength, size_t* outBlobSize);

/* Gets the number of bytes in an entry */
extern int32 (*get_entry_length)(int32 inStringID, int32 inLangID);

/* Get the maximum number of bytes for this language's entries */
extern int32 (*get_max_length)(int32 inLangID);

/* Returns a comma-delimited list of the names of the available
   languages (in the common directory) and returns the number of languages */
extern int32 (*get_language_list)(char** outList);

/* Gets a particular language name for language ID d */
extern char* (*language_name)(int32 inLangID, char* inBuffer, int32 inBuffSize);

/* Gets the language ID for a language called name */
extern int32 (*language_id)(char *inName);

/* Gets the raw bits for the Blithe bitmap */
extern size_t (*get_raw_bits)(void** theBits);

#endif
